' Setup type of chip and tell compiler the clock speed in Mhz
Device = 18F43K20           
Clock = 8

' Setup config options                      
Config FOSC = INTIO67       '
Config MCLRE = OFF
Config boren = off  ' this is a must if using coin cell batteries! the microcontroller always resets itself otherwise!

' import library's

' Register Setup

' Port Setup
' buttons first
Dim LogicInputA As PORTB.1
Dim LogicInputB As PORTB.2
Dim LogicSelect As PORTB.3
Dim FlipFlopSJTD As PORTB.4
Dim FlipFlopClock As PORTB.5
Dim FlipFlopRK As PORTB.6
Dim FlipFlopSelect As PORTB.7
Dim CounterUp As PORTA.0
Dim CounterDown As PORTA.1
' Now the LED's
Dim LogicInputALed As PORTA.2
Dim LogicInputBLed As PORTA.3
Dim NOTGateLED As PORTA.4
Dim ORGateLED As PORTA.5
Dim ANDGateLED As PORTA.6
Dim XORGateLED As PORTA.7
Dim NORGateLED As PORTE.0
Dim NANDGateLED As PORTE.1
Dim XNORGateLED As PORTE.2
Dim LogicGatesXLED As PORTC.0
Dim FlipFlopSJTDLED As PORTC.1
Dim FlipFlopClockLED As PORTC.2
Dim FlipFlopRKLED As PORTC.3
Dim SRFlipFlopLED As PORTC.4
Dim JKFlipFlopLED As PORTC.5
Dim TFlipFlopLED As PORTD.0
Dim DFlipFlopLED As PORTD.1
Dim FlipFlopQLED As PORTD.2
Dim FlipFlopNOTQLED As PORTD.3
Dim Counter8LED As PORTD.4
Dim Counter4LED As PORTD.5
Dim Counter2LED As PORTD.6
Dim Counter1LED As PORTD.7

' Variable arrays                     

' variables
Dim WhichLogicGate As Byte
Dim WhichFlipFlop As Byte
Dim CounterCount As Byte
Dim LogicInputAPressed As Boolean
Dim LogicInputBPressed As Boolean
Dim LogicSelectPressed As Boolean
Dim FlipFlopSJTDPressed As Boolean
Dim FlipFlopClockPressed As Boolean
Dim FlipFlopRKPressed As Boolean
Dim FlipFlopSelectPressed As Boolean
Dim CounterUpPressed As Boolean
Dim CounterDownPressed As Boolean
Dim ClockEdge As Boolean  

'Interrupts

' Sub Routines
Sub DoLogicGates()
    ' check the change gate button
    If LogicSelect = 1 And LogicSelectPressed = false Then
        LogicSelectPressed = true
        Inc(WhichLogicGate)
        LogicInputALed = 0
        LogicInputBLed = 0
        If WhichLogicGate > 6 Then
            WhichLogicGate = 0
        EndIf
    ElseIf LogicSelect = 0 Then
        LogicSelectPressed = false
    EndIf
    ' check input A button
    If LogicInputA = 1 And LogicInputAPressed = false Then
        LogicInputAPressed = true
        If LogicInputALed = 0 Then
            LogicInputALed = 1
        Else
            LogicInputALed = 0
        EndIf
    ElseIf LogicInputA = 0 Then
        LogicInputAPressed = false
    EndIf
    ' check input B button
    If LogicInputB = 1 And LogicInputBPressed = false And WhichLogicGate <> 0 Then
        LogicInputBPressed = true
        If LogicInputBLed = 0 Then
            LogicInputBLed = 1
        Else
            LogicInputBLed = 0
        EndIf
    ElseIf LogicInputB = 0 Then
        LogicInputBPressed = false
    EndIf
    ' Now output the results
    Select WhichLogicGate
        Case 0
            If LogicInputALed = 0 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf    
            NOTGateLED = 1
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0
        Case 1
            If LogicInputALed = 1 Or LogicInputBLed = 1 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 1
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 2
            If LogicInputALed = 1 And LogicInputBLed = 1 Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 1
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 3
            If (LogicInputALed = 0 And LogicInputBLed = 1) Or (LogicInputALed = 1 And LogicInputBLed = 0) Then
                LogicGatesXLED = 1
            Else
                LogicGatesXLED = 0
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 1
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 4
            If LogicInputALed = 1 Or LogicInputBLed = 1 Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 1
            NANDGateLED = 0
            XNORGateLED = 0 
        Case 5
            If LogicInputALed = 1 And LogicInputBLed = 1 Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 1
            XNORGateLED = 0 
        Case 6
            If (LogicInputALed = 0 And LogicInputBLed = 1) Or (LogicInputALed = 1 And LogicInputBLed = 0) Then
                LogicGatesXLED = 0
            Else
                LogicGatesXLED = 1
            EndIf
            NOTGateLED = 0
            ORGateLED = 0
            ANDGateLED = 0
            XORGateLED = 0
            NORGateLED = 0
            NANDGateLED = 0
            XNORGateLED = 1
    End Select    
End Sub

Sub DoFlipFlops()
    ' check the change flip flop button
    If FlipFlopSelect = 1 And FlipFlopSelectPressed = false Then
        FlipFlopSelectPressed = true
        Inc(WhichFlipFlop)
        FlipFlopSJTDLED = 0
        FlipFlopRKLED = 0
        If WhichFlipFlop > 3 Then
            WhichFlipFlop = 0
        EndIf
    ElseIf FlipFlopSelect = 0 Then
        FlipFlopSelectPressed = false
    EndIf
    ' check input SJTD button
    If FlipFlopSJTD = 1 And FlipFlopSJTDPressed = false Then
        FlipFlopSJTDPressed = true
        If FlipFlopSJTDLED = 0 Then
            FlipFlopSJTDLED = 1
        Else
            FlipFlopSJTDLED = 0
        EndIf
    ElseIf FlipFlopSJTD = 0 Then
        FlipFlopSJTDPressed = false
    EndIf
    ' check input RK button
    If FlipFlopRK = 1 And FlipFlopRKPressed = false And WhichFlipFlop < 2 Then  ' only do this one for the SR and JK flip flops
        FlipFlopRKPressed = true
        If FlipFlopRKLED = 0 Then
            FlipFlopRKLED = 1
        Else
            FlipFlopRKLED = 0
        EndIf
    ElseIf FlipFlopRK = 0 Then
        FlipFlopRKPressed = false
    EndIf
    ' check input Clock button
    If FlipFlopClock = 1 And FlipFlopClockPressed = false Then 
        FlipFlopClockPressed = true
        FlipFlopClockLED = 1
        ClockEdge = true
    ElseIf FlipFlopClock = 0 Then
        FlipFlopClockPressed = false
        FlipFlopClockLED = 0
    EndIf
    ' Now output the results
    Select WhichFlipFlop
        Case 0
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 And FlipFlopRKLED = 0 Then
                    ' don't do anything because it is no change!
                ElseIf FlipFlopSJTDLED = 0 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 1
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 0 Then
                    FlipFlopQLED = 1
                    FlipFlopNOTQLED = 0
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 0
                EndIf
            EndIf 
            SRFlipFlopLED = 1
            JKFlipFlopLED = 0
            TFlipFlopLED = 0
            DFlipFlopLED = 0
        Case 1
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 And FlipFlopRKLED = 0 Then
                    ' don't do anything because it is no change!
                ElseIf FlipFlopSJTDLED = 0 And FlipFlopRKLED = 1 Then
                    FlipFlopQLED = 0
                    FlipFlopNOTQLED = 1
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 0 Then
                    FlipFlopQLED = 1
                    FlipFlopNOTQLED = 0
                ElseIf FlipFlopSJTDLED = 1 And FlipFlopRKLED = 1 Then
                    Toggle(FlipFlopQLED)
                    Toggle(FlipFlopNOTQLED)
                EndIf
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 1
            TFlipFlopLED = 0
            DFlipFlopLED = 0 
        Case 2
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                If FlipFlopSJTDLED = 0 Then
                    ' do nothing!
                Else
                    Toggle(FlipFlopQLED)
                    Toggle(FlipFlopNOTQLED)
                EndIf
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 0
            TFlipFlopLED = 1
            DFlipFlopLED = 0 
        Case 3
            If ClockEdge = true Then
                ClockEdge = false   ' reset the clock edge
                FlipFlopQLED = FlipFlopSJTDLED
                FlipFlopNOTQLED = FlipFlopSJTDLED Xor %1
            EndIf 
            SRFlipFlopLED = 0
            JKFlipFlopLED = 0
            TFlipFlopLED = 0
            DFlipFlopLED = 1
    End Select    
End Sub

Sub DoCounter()
    ' check the Up and Down buttons
    If CounterUp = 1 And CounterUpPressed = false Then
        CounterUpPressed = true
        Inc(CounterCount)
        If CounterCount > 15 Then
            CounterCount = 0
        EndIf
    ElseIf CounterUp = 0 Then
        CounterUpPressed = false
    EndIf 
    If CounterDown = 1 And CounterDownPressed = false Then
        CounterDownPressed = true
        Dec(CounterCount)
        If CounterCount = 255 Then
            CounterCount = 15
        EndIf
    ElseIf CounterDown = 0 Then
        CounterDownPressed = false
    EndIf
    ' Now display the count
    Counter8LED = CounterCount.bits(3)
    Counter4LED = CounterCount.bits(2)
    Counter2LED = CounterCount.bits(1)
    Counter1LED = CounterCount.bits(0)    
End Sub

' Start Of Program - this is where we setup everything before getting into the main loop

' Oscillator setup
OSCCON = %01100000          ' device enters sleep on IDLE, 8Mhz Clock,   
OSCTUNE = %00000000         ' Internal oscillator low freq comes from 31Khz clock from LFINTOSC, PLL disabled

' Analog / Digital pins setup
ANSEL = %00000000          ' disable all analog inputs (make them all digital) must do this!
ANSELH = %00000000         ' disable all analog inputs (make them all digital) must do this!

' Tristate setup
TRISA = %00000011
TRISB = %11111110
TRISC = %00000000
TRISD = %00000000
TRISE = %00000000

' variable setup
WhichLogicGate = 0 
WhichFlipFlop = 0  
CounterCount = 0  
LogicInputAPressed = false  
LogicInputBPressed = false   
LogicSelectPressed = false   
FlipFlopSJTDPressed = false   
FlipFlopClockPressed = false   
FlipFlopRKPressed = false   
FlipFlopSelectPressed = false   
CounterUpPressed = false   
CounterDownPressed = false

'port setup
LogicInputALed = 0
LogicInputBLed = 0
NOTGateLED = 1
ORGateLED = 0
ANDGateLED = 0
XORGateLED = 0
NORGateLED = 0
NANDGateLED = 0
XNORGateLED = 0
FlipFlopSJTDLED = 0
FlipFlopClockLED = 0
FlipFlopRKLED = 0
SRFlipFlopLED = 1
JKFlipFlopLED = 0
TFlipFlopLED = 0
DFlipFlopLED = 0
FlipFlopQLED = 0 
FlipFlopNOTQLED = 1 
Counter8LED = 0 
Counter4LED = 0 
Counter2LED = 0 
Counter1LED = 0  
ClockEdge = false


While true()
    DoLogicGates
    DoFlipFlops
    DoCounter
Wend            











 

 

 
 
